<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateVariablesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_variables', function(Blueprint $table)
		{
			$table->integer('id');
			$table->integer('system_id');
			$table->string('name', 64);
			$table->tinyInteger('type')->default(0);
			$table->string('value');
		});

		Schema::table('a_variables', function($t)
		{
			$t->index('id');
			$t->index('system_id');
			$t->index('name');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_variables');
	}

}
