<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEventsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_events', function(Blueprint $table)
		{
			$table->integer('id')->unsigned();
			$table->integer('room_id')->unsigned();
			$table->integer('order')->unsigned();
			$table->string('image_name', 128);
			$table->string('display_text');
			$table->boolean('hidden_option')->default(0);
			$table->text('macro');
			$table->boolean('hidden')->default(0);
			$table->boolean('default_state');
			$table->tinyInteger('option');
			$table->integer('day_week');
			$table->time('time');			
		});

		Schema::table('a_events', function($t)
		{
			$t->index('id');
			$t->index('room_id');	
			$t->index('order');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_events');
	}

}
