<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTimezoneTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('timezone', function(Blueprint $table)
		{
			$table->increments('id');
			$table->string('name', 64)->unique()->index();
			$table->integer('bias');
			$table->string('s_name', 64)->default('');
			$table->string('s_time', 32);
			$table->integer('s_bias');
			$table->string('d_name', 64)->default('');//default(-1);
			$table->string('d_time', 32);
			$table->integer('d_bias');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('timezone');
	}

}
