<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBstationsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_bstations', function(Blueprint $table)
		{
			$table->increments('id');
			$table->integer('system_id')->unsigned()->index();
			$table->integer('room_id')->unsigned()->index();
			$table->string('name', 32);
			$table->string('mac', 32)->unique();
			$table->string('type', 32);
			$table->boolean('master')->default(0);
			$table->tinyInteger('light_level')->default(2);
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_bstations');
	}

}
