<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRemotesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_remotes', function(Blueprint $table)
		{
			$table->increments('id');
			$table->integer('system_id')->unsigned()->index();
			$table->integer('room_id')->unsigned()->index();
			$table->string('name', 32)->default('');
			$table->string('mac', 32)->unique();
			$table->string('type', 32)->default('');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_remotes');
	}

}
