<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBtnsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_btns', function(Blueprint $table)
		{
			$table->integer('id')->unsigned();
			$table->integer('device_id');//not unsigned();=>-1:room btn
			$table->integer('room_id')->unsigned();
			$table->integer('link_id')->default(-1);//not unsigned();=>-1:not linked
			$table->integer('page_id')->default(-1);
			$table->tinyInteger('page_btn_idx')->default(-1);
			$table->boolean('auto_wait')->default(0);
			$table->tinyInteger('edit_type')->default(1);
			$table->tinyInteger('popup')->default(0);
			$table->string('image_name', 128);
			$table->string('display_text');
			$table->boolean('hidden_option')->default(0);
			$table->text('activity');
			$table->text('macro');
			$table->boolean('hidden')->default(0);
			$table->boolean('page_hidden')->default(0);
		});

		Schema::table('a_btns', function($t)
		{
			$t->index('id');
			$t->index('device_id');
			$t->index('room_id');	
			$t->index('link_id');	
			$t->index('page_id');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_btns');
	}

}
