<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDevicesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_devices', function(Blueprint $table)
		{
			$table->integer('id')->unsigned();
			$table->integer('room_id')->unsigned();
			$table->tinyInteger('dev_type')->default(0);//0:Normal, 1:Twoway
			$table->string('category', 32)->default('');//default(-1);
			$table->string('brand', 32)->default('');//default(-1);
			$table->string('model', 64)->default('');//default(-1);
			$table->integer('model_id')->default(-1);
			$table->integer('meta_pwr_on')->default(-1);
			$table->integer('meta_pwr_off')->default(-1);
			$table->integer('meta_pwr_toggle')->default(-1);			
			$table->integer('meta_in_toggle')->default(-1);			
			$table->integer('page_id_start')->unsigned()->default(0);
			$table->integer('btn_id_start')->unsigned()->default(0);
			$table->integer('punch_vol')->default(-1);
			$table->tinyInteger('repeat_min')->unsigned()->default(3);
			$table->tinyInteger('repeat_macro')->unsigned()->default(3);
			$table->integer('ramp_start')->unsigned()->default(100);
			$table->integer('ramp_speed')->unsigned()->default(100);
			$table->integer('con_time')->unsigned()->default(0);
			$table->integer('delay_after_send')->unsigned()->default(50);
			$table->boolean('auto_cr')->default(0);
			$table->boolean('fav_option')->default(0);
			$table->integer('fav_delay')->unsigned()->default(400);
			$table->boolean('fav_enter')->default(1);
			$table->string('name', 64);
			$table->integer('target_bstation')->default(-1);
			$table->integer('target_type')->unsigned()->default(3);
			$table->string('target_addr', 32)->default('');
			$table->integer('target_port')->default(-1);
		});

		Schema::table('a_devices', function($t)
		{
			$t->index('id');
			$t->index('room_id');		
			$t->index('target_addr');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_devices');
	}

}
