<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRoomsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_rooms', function(Blueprint $table)
		{
			$table->increments('id');
			$table->integer('system_id')->unsigned()->index();
			$table->integer('device_id_start')->unsigned()->default(0);			
			//$table->integer('twoway_device_id_start')->unsigned()->default(10000000);	
			$table->integer('main_device_id')->default(-1);
			$table->integer('event_id_start')->unsigned()->default(0);
			//$table->boolean('master')->default(0);
			//$table->tinyInteger('light_level')->default(2);
			//$table->string('bstation', 32)->unique();
			//$table->string('remote', 32)->index();
			$table->string('name', 64);			
			$table->integer('client_assign')->default(-1);
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_rooms');
	}

}
