<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSystemsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('a_systems', function(Blueprint $table)
		{
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('controller_id');
			$table->string('name', 64);
			$table->integer('timezone_id')->default(-1);
			$table->boolean('timezone_dst')->default(1);
			$table->integer('time_type')->default(0);
			$table->tinyInteger('home_btn_option')->default(0);
			$table->integer('var_id_start')->default(0);
			$table->integer('twoway_device_id_start')->unsigned()->default(10000000);	
			$table->string('dealer_id', 32)->index();
			$table->string('dealer_grp_id', 32)->index();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('a_systems');
	}

}
