<?php

require_once('URCSystemData.php');
require_once('URCJWTWork.php');

class UserController extends BaseController {

	public function doClass($funcType) {

		if($funcType == 'inituserall') {

			/*
			$users = DB::connection('editor_common')->table('user')->join('user_detail', function($join)
			{
				$join->on('user.id', '=', 'user_detail.user_id')
					->where('user.editor', '=', Config::get('editorenv.editor_type'));
			})->get();

			DB::table('user')->delete();
			DB::table('user_detail')->delete();

			foreach($users as $user) {

				$userData = array('id' => $user->id,
					'username' => $user->username, 
					'password' => $user->password,
					'level' => $user->level,
					'sip_id' => $user->username,
					'cloud_id' => $user->cloud_id,
					'hdr' => $user->hdr,
					'status' => $user->status,
					'opt_menu_show' => $user->opt_menu_show,
					'opt_help_show' => $user->opt_help_show,
					'editor' => $user->editor,
					'created_at' => $user->created_at,
					'updated_at' => $user->updated_at);
				DB::table('user')->insert($userData);

				$usrDetailData = array('user_id' => $user->user_id,
					'user_email' => $user->user_email);	
				DB::table('user_detail')->insert($usrDetailData);
			}			
			*/

			/*

			$users = DB::table('user')->get();
			foreach($users as $user) {

				$systems = DB::table('a_systems')->where('user_id', '=', $user->id)->get();
				foreach($systems as $system) {

					$mac = BStationManager::getMACFromControllerId($system->controller_id);
					$arData = array('mac' => $mac, 'sip_id' => $user->sip_id, 'password' => $user->password, 'controller_id' => $system->controller_id);

					try
					{
						DB::table('sip_user')->insert($arData);
					}
					catch(\Exception $e) 
					{
						$existing = DB::table('sip_user')->where('mac', '=', $mac)->first();
						if($existing) {
							if($existing->controller_id != $system->controller_id) {
								ErrorDebug::write('-------------------------------------');
								ErrorDebug::write('New CtrlID:'.$system->controller_id);
								ErrorDebug::write('Existing:  '.$existing->controller_id);
								ErrorDebug::write('New SipID:'.$user->sip_id);
								ErrorDebug::write('Existing:  '.$existing->sip_id);
								ErrorDebug::write('New Passwo:'.$user->password);
								ErrorDebug::write('Existing:  '.$existing->password);
							}
							if($existing->sip_id  != $user->sip_id) {
								ErrorDebug::write('New SipID:'.$user->sip_id);
								ErrorDebug::write('Existing:  '.$existing->sip_id);
							}
							if($existing->password != $user->password) {
								ErrorDebug::write('New Passwo:'.$user->password);
								ErrorDebug::write('Existing:  '.$existing->password);
							}
						}
						else {
							ErrorDebug::write('sip_err:'.json_encode($arData));
						}
					}
				}
			}

			*/
			
			return Response::json(array('result' => true));//'db error'));
		}


		if($funcType == 'create') {

			$rules = array(
				'modelType' => 'Required',
				'key' => 'Required|min:16',
				'email' => 'Required|Between:3,255|Email',
				'tempPassword' => 'Required',
				'username' => 'Required',
				'password' => 'Required',
				'userEmail' => 'Required|Between:3,255|Email');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}
			
			$modelType = Input::get('modelType');//HCM-C1';
			$keyValue = Input::get('key');
			$email = Input::get('email');
			$tempPassword = Input::get('tempPassword');
			$username = Input::get('username');
			$password = Input::get('password');
			$userEmail = Input::get('userEmail');

			$progKey = BStationManager::genKeyFromUserData($modelType, $keyValue);
			if($progKey === false) {
				return Response::json(array('result' => false, 'error' => 'invalid type key'));
			}

			//Check User
			if(Config::get('editorenv.debugSkipEmail') != true) {
				if(!EmailReg::checkValidUser($email, $tempPassword, $progKey)) {
					return Response::json(array('result' => false, 'error' => 'Please check your information. Something was entered incorrectly.'));
				}
			}

			//Check Existing
			$newUser = new User;
			if($newUser->getUserByUsername($username)) {
				return Response::json(array('result' => false, 'error' => 'already existing user'));
			}			

			$existingEmail = UserDetail::where('user_email', '=', $userEmail)->first();
			if($existingEmail) {
				return Response::json(array('result' => false, 'error' => 'This email address is already in use.'));
			}
			
			
			$newUser->username = $username;
			$newUser->password = Crypt::encrypt($password);
			$newUser->hdr = 'a';
			$newUser->status = '1';
			$newUser->editor = Config::get('editorenv.editor_type');
			//$newUser->sip_id = '';

			//DB insert
			try
			{
				DB::transaction(function() use ($newUser, $userEmail)
				{	
					if(!$newUser->save()) {
						throw new \Exception('db error');
					}
					
					$newUserDetail = new UserDetail;
					$newUserDetail->user_id = $newUser->id;
					$newUserDetail->user_email = $userEmail;						
					if(!$newUserDetail->save()) {
						throw new \Exception('db error');
					}
				});
			}
			catch(\Exception $e) 
			{
				return Response::json(array('result' => false, 'error' => $e->getMessage()));//'db error'));
			}

			//Login
			//JWT->Auth::login($newUser);
			/*
			$user = array(
				'username' => $username, 'password' => $password
				);

			if(!Auth::attempt($user, true)) {
				return Response::json(array('result' => false, 'error' => 'login error'));
			}
			*/

			$mac = '';
			$modelTypeId = '';
			$randId = '';
			if(!BStationManager::getDataFromKey($progKey, $mac, $modelTypeId, $randId)) {
				return Response::json(array('result' => false, 'error' => 'system Key error'));
			} 

			//EmailController::sendEmail($userEmail, "Welcome!",
			//	'<h2>Welcome!<o:p></o:p></h2>'.
			//	'<p>Your account has been created for your '.Config::get('editorenv.editor_name').' control system. &nbsp;Your username is below.&nbsp;</p>'.
			//	'<p>Your username: &nbsp;'.$username.'</p>'.
			//	'<p>&nbsp;</p> <p>Thank you!</p> <p>URC</p>');

			EmailController::sendEmail($userEmail, "Welcome!", file_get_contents('./images/enduser_email.html'));

			$editor_type = Config::get('editorenv.editor_type');
			$userChk = User::where('username', '=', $username)->where('editor', '=', $editor_type)->first();
			$token = URCJWTWork::genJWTToken($username, $userChk->id, $userChk->level);
			return Response::json(array('result' => true, 'status' => true, 'mac' => $mac, 'email' => $userEmail, 'token' => $token, 
				'opt_menu_show' => $userChk->opt_menu_show, 'opt_help_show' => $userChk->opt_help_show));
		}
		else if($funcType == 'login_for_create') {

			$rules = array(
				'modelType' => 'Required',
				'key' => 'Required|min:16',
				'username' => 'Required',
				'password' => 'Required');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			$modelType = Input::get('modelType');//HCM-C1';
			$keyValue = Input::get('key');
			$username = Input::get('username');
			$password = Input::get('password');
			
			//check ID Password
			$editor_type = Config::get('editorenv.editor_type');
			$userChk = User::where('username', '=', $username)->where('editor', '=', $editor_type)->first();
			//ErrorDebug::write(Crypt::decrypt($userChk->password));
			//ErrorDebug::write($password);
			if(!$userChk) {
				return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
			}
			/*
			if($userChk->password_tmp_set) {
				if($password !== Crypt::decrypt($userChk->password_tmp)) {
					return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
				}

				$userDetail = DB::table('user_detail')->where('user_id', '=', $userChk->id)->first();

				$skipChecking = false;
				if(Input::has('bstationChk') && ((int)Input::get('bstationChk')) === 0) {
					$skipChecking = true;
				}
				$result = $this->updateTempPassword($userChk, $userDetail->user_email, $skipChecking);
				if($result === false) {
					return Response::json(array('result' => false, 'error' => 'Communication Error - Fail to update user'));
				}
				if($result !== true) {
					
					return Response::json(array('result' => true, 'status' => false, 'info' => $result, 
						'opt_menu_show' => $userChk->opt_menu_show, 'opt_help_show' => $userChk->opt_help_show));
					//return Response::json(array('result' => false, 'error' => 'The basestation is not connected'));
				}
			}
			else {
			*/
				if($password !== Crypt::decrypt($userChk->password)) {
					return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
				}
			//}

			$progKey = BStationManager::genKeyFromUserData($modelType, $keyValue);
			if($progKey === false) {
				return Response::json(array('result' => false, 'error' => 'invalid type key'));
			}

			//check registered Bstation

			//Key Check			
			if(Config::get('editorenv.debugSkipBStationChk') != true) {

				$mgr = new BStationManager(URCValues::WAIT_SEC); 
				if($mgr->customCheckKey($progKey) !== true) {
					return Response::json(array('result' => false, 'error' => $mgr->getErrResult()));
				}
			}
				
			//Login
			//JWT->Auth::login($userChk);

			/*
			$user = array(
				'username' => $username, 'password' => $password
				);

			if(!Auth::attempt($user, true)) {
				return Response::json(array('result' => false, 'error' => 'login fail'));
			}
			*/

			$macAddr = '';
			$modelTypeId = '';
			$randId = '';
			if(!BStationManager::getDataFromKey($progKey, $macAddr, $modelTypeId, $randId)) {
				return Response::json(array('result' => false, 'error' => 'Invalud Key value'));
			}
			
			$userDetail = UserDetail::where('user_id', '=', $userChk->id)->first();

			$token = URCJWTWork::genJWTToken($username, $userChk->id, $userChk->level);
			return Response::json(array('result' => true, 'status' => true, 'mac' => $macAddr, 'email' => $userDetail->user_email, 'token' => $token, 
				'opt_menu_show' => $userChk->opt_menu_show, 'opt_help_show' => $userChk->opt_help_show));
		} 
		else if($funcType == 'login') {

			/*
			//for testing delete all user
			ErrorDebug::write('deleteUsers');
			$bstationMgr = new BStationManager(URCValues::WAIT_SEC);
			ErrorDebug::write('deleteUsers1');
			$dbDel = DB::table('user')->select('username', 'password', 'cloud_id')->get();
			ErrorDebug::write('deleteUsers2');
			foreach($dbDel as $dbItem) {
				ErrorDebug::write('deleteUsers3');
				if($bstationMgr->deleteUser($dbItem->username) == false) {
					ErrorDebug::write('fail : '.$dbItem->username);
				}
			}
			return Response::json(array('result' => false, 'error' => 'del user'));
			*/			


/*
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://urclinux1.cloudapp.net:3000/sip/sendCommand');
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false );
//ErrorDebug::write('curl_req2'.$data);
//http_build_query
$data = array("fromUser" => "urcuser1", "fromUserPassword" => "password", 
	"baseStationUser" => "urcuser200", "JsonCommand" => "TestCommand");

$dataJson = json_encode($data);
curl_setopt($ch, CURLOPT_POST, true );
curl_setopt($ch, CURLOPT_POSTFIELDS, $dataJson);

curl_setopt($ch, CURLOPT_HTTPHEADER, array(//'Authorization: Basic '.$authorization, 
	'Content-Type: application/json','Content-Length: ' . strlen($dataJson)));

$resultData = curl_exec($ch);
//ErrorDebug::write('curl_req3Result:'.$resultData);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

curl_close($ch);

ErrorDebug::write($resultData);

		return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
*/


			$rules = array(
				'username' => 'Required',
				'password' => 'Required');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			$username = Input::get('username');
			$password = Input::get('password');

			$simple = 0;
			if(Input::has('simple')) {
				$simple = Input::get('simple');
			}

			/*
			if($username == 'AndreLalande') {
				$this->deleteUser($username, $password);
			}
			*/

			$emailValidator = Validator::make(
			    array('email' => $username),
			    array('email' => array('email'))
			);

			if(!$emailValidator->fails() ) {
				return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
			}
			
			//check ID Password
			$editor_type = Config::get('editorenv.editor_type');
			$userChk = User::where('username', '=', $username)->where('editor', '=', $editor_type)->first();

			//ErrorDebug::write(Crypt::decrypt($userChk->password));
			//ErrorDebug::write($password);
			if(!$userChk) {
				//ErrorDebug::write(Crypt::decrypt($userChk->password));
				return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
			}

			
			/*
			if($userChk->password_tmp_set) {
				if($password !== Crypt::decrypt($userChk->password_tmp)) {
					//ErrorDebug::write(Crypt::decrypt($userChk->password_tmp));
					return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
				}

				$userDetail = DB::table('user_detail')->where('user_id', '=', $userChk->id)->first();
				$skipChecking = false;
				if(Input::has('bstationChk') && ((int)Input::get('bstationChk')) === 0) {
					$skipChecking = true;
				}

				$result = $this->updateTempPassword($userChk, $userDetail->user_email, $skipChecking);
				if($result === false) {
					return Response::json(array('result' => false, 'error' => 'Communication Error - Fail to update user'));
				}
				if($result !== true) {

					return Response::json(array('result' => true, 'status' => false, 'info' => $result, 
						'opt_menu_show' => $userChk->opt_menu_show, 'opt_help_show' => $userChk->opt_help_show));
					//return Response::json(array('result' => false, 'error' => 'The basestation is not connected'));
				}
			}
			else {
			*/
				if($password !== Crypt::decrypt($userChk->password)) {
					return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
				}
			//}

			if($simple != 1) {
				if($userChk->opt_allow_edit == 0) {
					return Response::json(array('result' => false, 'code' => 'ACCESS_DENY', 'error' => 'Programming access has been disabled by the user.'));
				}
			}
			

			/*
			DB::table('user')->where('username', '=', 'cyrpro')->update(array('cloud_id' => 'f23da2d5-994d-4019-bf2e-efae2aa49f75'));
			DB::table('a_systems')->where('id', '=', 1)->update(array('controller_id' => '00010001-4354-524C-494E-8C89A5C9D594'));
			DB::table('a_rooms')->where('id', '=', 1)->where('system_id', '=', 1)->
				update(array('bstation' => '8C89A5C9D594'));
			*/
				
			//Login
			//JWT->Auth::login($userChk);
			/*
			if(!Auth::attempt($user, true)) {
				return Response::json(array('result' => false, 'error' => 'login fail'));
			}
			*/

			/*
			$resultData = '';
			$bstationMgr = new BStationManager(URCValues::WAIT_SEC);
			if($bstationMgr->getBasestations($username, $password, $userChk->cloud_id, '', 1000, $resultData)) {
				ErrorDebug::write('getBasestations');
				ErrorDebug::write($resultData);
			}
			
			if($username == 'carlsmith') {
				ErrorDebug::write('test1');
				$arController = array();
				$userDetail = DB::table('user_detail')->where('user_id', '=', $userChk->id)->first();
				if($bstationMgr->updateUser($username, $password, $password, $userChk->cloud_id, 
					$userDetail->user_email, $arController, true) == false) {
					return Response::json(array('result' => false, 'error' => $bstationMgr->getErrResult()));
				}
			}
			*/

			//Get System List
			$urcSystem = new URCSystemData($userChk->id);			
			$systems = $urcSystem->getSystems();
			//if($username == 'cyrpro1974') {

				/*
				$users = DB::table('user')->get();
				foreach($users as $user) {
					ErrorDebug::write('user'.$user->id.':'.$user->username);
					$urcChkSystem = new URCSystemData($user->id);			
					$chkSystems = $urcChkSystem->getSystems();					
					foreach($chkSystems as $system) {
						if($urcChkSystem->validSystemMain($system->id, $errMsg) === false) {
							ErrorDebug::write('valid'.$system->id.':'.$errMsg);
						}
					}
				}
				*/

				/*
				$urcChkSystem = new URCSystemData($userChk->id);			
				$chkSystems = $urcChkSystem->getSystems();					
				foreach($chkSystems as $system) {
					if($urcChkSystem->validSystemMain($system->id, $errMsg) === false) {
						ErrorDebug::write('valid'.$system->id.':'.$errMsg);
					}
				}
				*/
			//}
			
			$userDetail = UserDetail::where('user_id', '=', $userChk->id)->first();
			$token = URCJWTWork::genJWTToken($username, $userChk->id, $userChk->level);
			
			return Response::json(array('result' => true, 'status' => true, 'systems' => $systems, 'email' => $userDetail->user_email, 'token' => $token,
			 'opt_menu_show' => $userChk->opt_menu_show, 'opt_help_show' => $userChk->opt_help_show));
		}
		else if($funcType == 'user_info') {

			//JWT->
			/*
			if(!Auth::check()) {
				return Response::json(array('result' => false, 'error' => 'You must sign in'));
			}
			*/

			$username = '';
			$id = -1;
			$errMsg = '';
			$errNo = -1;
			if(!URCJWTWork::chkJWTToken($username, $id, $level, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}

			/*
			if($level !== URCValues::LOGIN_USER) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}
			*/

			$userChk = DB::table('user')->join('user_detail', function($join) use ($id)
			{
				$join->on('user.id', '=', 'user_detail.user_id')
					->where('user.id', '=', $id)->where('user.editor', '=', Config::get('editorenv.editor_type'));
			})->first();

			if(!$userChk) {
				return Response::json(array('result' => false, 'error' => 'db error'));
			}

			return Response::json(array('result' => true,
				'username' => $userChk->username, 'email' => $userChk->user_email ));
		}
		else if($funcType == 'new_email') {

			//JWT->
			/*
			if(!Auth::check()) {
				return Response::json(array('result' => false, 'error' => 'You must sign in'));
			}
			*/

			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}
			if(!$this->chkUser()) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}

			$rules = array(
				'email' => 'Required|Between:3,255|Email',
				'password' => 'Required');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			$password = Input::get('password');
			$newEmail = Input::get('email');

			if($password !== Crypt::decrypt($this->usr->password)) {
				return Response::json(array('result' => false, 'error' => 'wrong password'));
			}

			$updatedRow = DB::table('user_detail')->where('user_id', '=', $this->usr_id)->
				update(array('user_email' => $newEmail));

			
			if($updatedRow <= 0) {
				return Response::json(array('result' => false, 'error' => 'db error'));
			}

			return Response::json(array('result' => true));
		}
		else if($funcType == 'new_password') {

			//JWT->
			/*
			if(!Auth::check()) {
				return Response::json(array('result' => false, 'error' => 'You must sign in'));
			}
			*/

			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}
			if(!$this->chkUser()) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}

			$rules = array(
				'old_password' => 'Required',
				'new_password' => 'Required');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			$pass_old = Input::get('old_password');
			$pass_new = Input::get('new_password');

			if($pass_old !== Crypt::decrypt($this->usr->password)) {
				return Response::json(array('result' => false, 'error' => 'wrong password'));
			}

			DB::table('user')->where('id', '=', $this->usr_id)->
				update(array('password' => Crypt::encrypt($pass_new)));

			return Response::json(array('result' => true));
		}
		else if($funcType == 'get_option') {

			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}
			if(!$this->chkUser()) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}

			$userChk = User::where('id', '=', $this->usr_id)->first();
			if(!$userChk) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}

			$option = new stdClass;
			$option->menu_show = $userChk->opt_menu_show;
			$option->help_show = $userChk->opt_help_show;
			return Response::json(array('result' => true, 'option' => $option));
		}
		else if($funcType == 'set_option') {

			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}
			if(!$this->chkUser()) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}

			$rules = array(
				'menu_show' => 'Required',
				'help_show' => 'Required');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			DB::table('user')->where('id', '=', $this->usr_id)->
				update(array('opt_menu_show' => Input::get('menu_show'), 'opt_help_show' => Input::get('help_show')));

			return Response::json(array('result' => true));			
		}
		if($funcType == 'get_installer_option') {

			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}
			if(!$this->chkUser()) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}

			$userChk = User::where('id', '=', $this->usr_id)->first();
			if(!$userChk) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}

			$option = new stdClass;
			$option->allow_edit = $userChk->opt_allow_edit;
			return Response::json(array('result' => true, 'option' => $option));
		}
		else if($funcType == 'set_installer_option') {

			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}
			if(!$this->chkUser()) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}

			$rules = array(
				'allow_edit' => 'Required');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			DB::table('user')->where('id', '=', $this->usr_id)->
				update(array('opt_allow_edit' => Input::get('allow_edit')));

			return Response::json(array('result' => true));			
		}

		return Response::json(array('result' => false, 'error' => 'unknown command'));
	}

	/*
	public function updateTempPassword($user, $email, $skipChecking) {

		$urcSystem = new URCSystemData($user->id);
		$arController = $urcSystem->getControllersByUserId();
			
		$bstationMgr = new BStationManager(URCValues::WAIT_SEC);			
		if($skipChecking != true) {

			//update cloud user
			if($bstationMgr->checkConnection($user->sip_id, Crypt::decrypt($user->password), $user->sip_id, $arController) == false) {
				foreach($arController as $item) {
					unset($item->id);
				}
				return $arController;			
			}
		}

		if($bstationMgr->updateUser($user->username, Crypt::decrypt($user->password), Crypt::decrypt($user->password_tmp), $user->sip_id, $email, $arController, $skipChecking) == false) {
			return false;
		}

		if($skipChecking != true) {
			foreach($arController as $item) {
				if($item->connection == 2) {
					ErrorDebug::write('Critical Error: mac:'.$item->mac.'  ctrl_id:'.$item->id);
				}
			}
		}

		//DB Update
		User::where('id', '=', $user->id)->
			update(array('password' => $user->password_tmp, 'password_tmp_set' => 0, 'password_tmp' => ''));

		return true;
	}
	*/

	public function deleteUser($username, $password) {
		
		$editor_type = Config::get('editorenv.editor_type');
		$userChk = User::where('username', '=', $username)->where('editor', '=', $editor_type)->first();

		//ErrorDebug::write(Crypt::decrypt($userChk->password));
		//ErrorDebug::write($password);
		if(!$userChk) {
			//ErrorDebug::write(Crypt::decrypt($userChk->password));
			return false;
		}

		if($password !== Crypt::decrypt($userChk->password)) {
			return false;
		}
		
		$urcSystem = new URCSystemData($userChk->id);
		$systems = $urcSystem->getSystems();

		foreach($systems as $system) {

			$urcSystem->destroySystem($system->id);
		}

		DB::table('a_download')->where('id', '=', $userChk->id)->delete();
		DB::table('user')->where('id', '=', $userChk->id)->delete();
		DB::table('user_detail')->where('user_id', '=', $userChk->id)->delete();

		return true;
	}

}
