<?php
require_once('ErrorDebug.php');

class URCUDMLData {

	var $dbSvr = null;
	var $userInfo = null;
	var $timeoutSec = null;

	var $user = null;
	var $dev = null;

	var $prg_ver = 'public';

	function __construct($user, $dev) {		
		
		$this->dbSvr = Config::get('editorenv.urcDBServerAddr');	
		$this->userInfo = Config::get('editorenv.urcDBServerUserInfo');
		$this->timeoutSec = 5;

		$this->user = $user;
		$this->dev = $dev;

		switch(Config::get('editorenv.prg_version')) {
		case 0:
			$this->prg_ver = 'public';
			break;
		case 1:
			$this->prg_ver = 'beta';
			break;
		case 2:
			$this->prg_ver = 'alpha';
			break;
		case 3:
			$this->prg_ver = 'rc';
			break;
		case 4:
			$this->prg_ver = 'factory';
			break;
		case 5:
			$this->prg_ver = 'eng';
			break;
		}

	}

	public static function isHardKeyId($id) {

		if($id > 2048)//0x0800 
			return false;

		return true;
	}

	public function curl_req($path, $req, $data = '')
	{
	    $ch = curl_init();

	    curl_setopt($ch, CURLOPT_URL, $this->dbSvr.$path);
	    curl_setopt($ch, CURLOPT_USERPWD, $this->userInfo);
	    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC); 
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $req);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false );
	    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	    
	    //http_build_query
	    if($req == 'POST') {
	    	curl_setopt($ch, CURLOPT_POST, true );
	    	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	    }

	    $result = curl_exec($ch);
	    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	    curl_close($ch);
	   	
	   	if($httpCode == 200) {
	   		;
	    	return $result;
	    }

	    //ErrorDebug::write($httpCode);

	    return false;
	}

	public function getDeviceTypes() {

		$requestURL = '/q/categories?ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}

		$result = $this->curl_req($requestURL, "GET");
		if($result == false) return null;
		
		$xml = simplexml_load_string($result);
		$data = StringGenerator::xmlToArray($xml);

		/*
		$data = array();
		foreach($data2['ROOT']['categories']['category'] as $item) {
			$data[] = (object) array('value' => $item['id'], 'label' => $item['name']);
		}
		*/

		if(isset($data['ROOT']['categories']['category'])) {
			return $data['ROOT']['categories']['category'];
		}

		$empty = array();
		return $empty;
	}

	public function getDefaultImage($category) {

		$requestURL = '/q/categories';

		$result = $this->curl_req($requestURL, "GET");
		if($result == false) return '';
		
		$xml = simplexml_load_string($result);
		$data = StringGenerator::xmlToArray($xml);

		$categores = $data['ROOT']['categories']['category'];

		$cnt = count($categores);
		for($i = 0; $i < $cnt; $i++) {
			if($categores[$i]['name'] === $category) {
				return $categores[$i]['icon'];
			}
		}

		return '';
	}

	public function getBrands($deviceType) {

		$requestURL = '/q/brandlist?category='.urlencode($deviceType).'&ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}

		//ErrorDebug::write($requestURL);
		
		$result = $this->curl_req($requestURL, "GET");
		if($result == false) return null;
		
		$xml = simplexml_load_string($result);
		
		$option = array('alwaysArray' => array('brand'));
		$data = StringGenerator::xmlToArray($xml, $option);
		/*
		$data = array();
		foreach($data2['ROOT']['brandlist']['brand'] as $item) {
			$data[] = (object) array('label' => $item['name']);
		}
		*/

		if(isset($data['ROOT']['brandlist']['brand'])) {
			return $data['ROOT']['brandlist']['brand'];
		}
		$empty = array();
		return $empty;
	}

	public function getDevices($deviceType, $brand) {
		
		$deviceType = urlencode($deviceType);
		$brand = urlencode($brand);

		$dataIR = array();
		$dataIP = array();

		$option = array('alwaysArray' => array('model'));

		$requestURL = '/q/modellist?category='.$deviceType.'&brand='.$brand.'&codeset=ir&ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}
		$result = $this->curl_req($requestURL, "GET");
		if($result !== false) {		
			$xml = simplexml_load_string($result);
			$data = StringGenerator::xmlToArray($xml, $option);
			if(isset($data['ROOT']['models']['model'])) {
				$dataIR = $data['ROOT']['models']['model'];
			}
		}

		$requestURL = '/q/modellist?category='.$deviceType.'&brand='.$brand.'&codeset=ip&ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}
		$result = $this->curl_req($requestURL, "GET");
		if($result !== false) {		
			$xml = simplexml_load_string($result);
			$data = StringGenerator::xmlToArray($xml, $option);
			if(isset($data['ROOT']['models']['model'])) {
				$dataIP = $data['ROOT']['models']['model'];
			}
		}

		return array('ir' => $dataIR, 'ip' => $dataIP);
	}

	public function searchDevices($deviceType, $brand, $searchStr) {
	
		$deviceType = urlencode($deviceType);
		$brand = urlencode($brand);
		$searchStr = urlencode($searchStr);

		$dataIR = array();
		$dataIP = array();
		$dataPopularIR = array();
		$dataPopularIP = array();

		$option = array('alwaysArray' => array('model'));
		if(strlen($searchStr) > 0) {
			$requestURL = '/q/modelsearch?category='.$deviceType.'&brand='.$brand.'&codeset=ir&model='.$searchStr.'&ver='.$this->prg_ver;
			if(strlen($this->user) > 0) {
				$requestURL .= '&usr='.urlencode($this->user);
			}
			$result = $this->curl_req($requestURL, "GET");
			if($result !== false) {		
				$xml = simplexml_load_string($result);
				$data = StringGenerator::xmlToArray($xml, $option);
				if(isset($data['ROOT']['models']['model'])) {
					$dataIR = $data['ROOT']['models']['model'];
				}
			}
			$requestURL = '/q/modelsearch?category='.$deviceType.'&brand='.$brand.'&codeset=ip&model='.$searchStr.'&ver='.$this->prg_ver;
			if(strlen($this->user) > 0) {
				$requestURL .= '&usr='.urlencode($this->user);
			}
			$result = $this->curl_req($requestURL, "GET");
			if($result !== false) {		
				$xml = simplexml_load_string($result);
				$data = StringGenerator::xmlToArray($xml, $option);
				if(isset($data['ROOT']['models']['model'])) {
					$dataIP = $data['ROOT']['models']['model'];
				}
			}
		}
		
		$requestURL = '/q/popularmodels?category='.$deviceType.'&brand='.$brand.'&codeset=ir&ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}
		$result = $this->curl_req($requestURL, "GET");
		if($result !== false) {		
			$xml = simplexml_load_string($result);
			$data = StringGenerator::xmlToArray($xml, $option);
			if(isset($data['ROOT']['models']['model'])) {
				$dataPopularIR = $data['ROOT']['models']['model'];
			}
		}
		$requestURL = '/q/popularmodels?category='.$deviceType.'&brand='.$brand.'&codeset=ip&ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}
		$result = $this->curl_req($requestURL, "GET");
		if($result !== false) {		
			$xml = simplexml_load_string($result);
			$data = StringGenerator::xmlToArray($xml, $option);
			if(isset($data['ROOT']['models']['model'])) {
				$dataPopularIP = $data['ROOT']['models']['model'];
			}
		}

		//ErrorDebug::write(json_encode(array('ir' => $dataIR, 'ip' => $dataIP, 'p_ir' => $dataPopularIR, 'p_ip' => $dataPopularIP)));

		return array('ir' => $dataIR, 'ip' => $dataIP, 'p_ir' => $dataPopularIR, 'p_ip' => $dataPopularIP);
	}

	public function searchDevicesCore($cmdStr, $deviceType, $brand) {
	
		$deviceType = urlencode($deviceType);
		$brand = urlencode($brand);

		$dataPopularIR = array();
		$dataPopularIP = array();

		$option = array('alwaysArray' => array('model'));
		
		$requestURL = '/q'.'/'.$cmdStr.'?category='.$deviceType.'&brand='.$brand.'&codeset=ir&ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}
		$result = $this->curl_req($requestURL, "GET");
		if($result !== false) {		
			$xml = simplexml_load_string($result);
			$data = StringGenerator::xmlToArray($xml, $option);
			if(isset($data['ROOT']['models']['model'])) {
				$dataPopularIR = $data['ROOT']['models']['model'];
			}
		}
		$requestURL = '/q'.'/'.$cmdStr.'?category='.$deviceType.'&brand='.$brand.'&codeset=ip&ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}
		$result = $this->curl_req($requestURL, "GET");
		if($result !== false) {		
			$xml = simplexml_load_string($result);
			$data = StringGenerator::xmlToArray($xml, $option);
			if(isset($data['ROOT']['models']['model'])) {
				$dataPopularIP = $data['ROOT']['models']['model'];
			}
		}

		//ErrorDebug::write(json_encode(array('ir' => $dataIR, 'ip' => $dataIP, 'p_ir' => $dataPopularIR, 'p_ip' => $dataPopularIP)));

		return array('p_ir' => $dataPopularIR, 'p_ip' => $dataPopularIP);
	}

	public function searchDevicesPopular($deviceType, $brand) {
	
		return $this->searchDevicesCore('popularmodels', $deviceType, $brand);
	}

	public function searchDevicesAll($deviceType, $brand) {
	
		return $this->searchDevicesCore('search_all_models', $deviceType, $brand);		
	}

	/*
	public function searchDevicesPopular($deviceType, $brand) {
	
		$deviceType = urlencode($deviceType);
		$brand = urlencode($brand);

		$dataPopularIR = array();
		$dataPopularIP = array();

		$option = array('alwaysArray' => array('model'));
		
		$requestURL = '/q/popularmodels?category='.$deviceType.'&brand='.$brand.'&codeset=ir&ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}
		$result = $this->curl_req($requestURL, "GET");
		if($result !== false) {		
			$xml = simplexml_load_string($result);
			$data = StringGenerator::xmlToArray($xml, $option);
			if(isset($data['ROOT']['models']['model'])) {
				$dataPopularIR = $data['ROOT']['models']['model'];
			}
		}
		$requestURL = '/q/popularmodels?category='.$deviceType.'&brand='.$brand.'&codeset=ip&ver='.$this->prg_ver;
		if(strlen($this->user) > 0) {
			$requestURL .= '&usr='.urlencode($this->user);
		}
		$result = $this->curl_req($requestURL, "GET");
		if($result !== false) {		
			$xml = simplexml_load_string($result);
			$data = StringGenerator::xmlToArray($xml, $option);
			if(isset($data['ROOT']['models']['model'])) {
				$dataPopularIP = $data['ROOT']['models']['model'];
			}
		}

		//ErrorDebug::write(json_encode(array('ir' => $dataIR, 'ip' => $dataIP, 'p_ir' => $dataPopularIR, 'p_ip' => $dataPopularIP)));

		return array('p_ir' => $dataPopularIR, 'p_ip' => $dataPopularIP);
	}
	*/

	public function getDevice($dbType, $modelId, $targetType) {
		
		switch($targetType) {
		case 1:
			$requestURL = '/q/functions?type='.$dbType.'&id='.$modelId.'&codeset=ir&ver='.$this->prg_ver;
			if(strlen($this->user) > 0) {
				$requestURL .= '&usr='.urlencode($this->user);
			}
			$result = $this->curl_req($requestURL, "GET");
			break;
		case 2:
			$requestURL = '/q/functions?type='.$dbType.'&id='.$modelId.'&codeset=ip&ver='.$this->prg_ver;
			if(strlen($this->user) > 0) {
				$requestURL .= '&usr='.urlencode($this->user);
			}
			$result = $this->curl_req($requestURL, "GET");
			break;
		default:
			return null;
		}

		if($result == false) return null;

		$option = array('alwaysArray' => array('function', 'item'));

		//ErrorDebug::write($result);
		$xml = simplexml_load_string($result);

		$data = StringGenerator::xmlToArray($xml, $option);

		//ErrorDebug::write(json_encode($data));

		$meta = array();
		if(isset($data['ROOT']['functions']['function'])) {
			$btnDB = $data['ROOT']['functions']['function'];

			if(isset($data['ROOT']['metadata']['item'])) {
				$meta = $data['ROOT']['metadata']['item'];
			}
		}
		else {
			$btnDB = array();
		}

		if(isset($data['ROOT']['keyboard']['key'])) {
			$keyDB = $data['ROOT']['keyboard']['key'];
		}
		else {
			$keyDB = array();
		}

		return array('attr' => $data['ROOT']['attributes'], 'keys' => $keyDB, 'btns' => $btnDB, 'meta' => $meta);
	}
}
