<?php

class FileController extends BaseController {

	public function doGetDeviceIcons($imageName) {

		if($imageName == 'info.json') {

			/*
			if(!Auth::check()) {
				return Response::view('errors.missing', array(), 404);
			}
			*/

			if(!file_exists('./images/device_icons/'.$imageName)) { 

				$files = glob('./images/device_icons/*.png');

				//$info = array();

				foreach($files as &$file) {
					$file = basename($file);

					$pos = strpos($file, '_');
					if($pos !== false) {
						$file = substr($file, 0, $pos);
					}
					else {
						$pos = strlen($file)-4;
						$file = substr($file, 0, $pos);//-4=.PNG
						//ErrorDebug::write('pos :'.$pos.':'.$file.':'.strlen($file).':'.$category);
					}

					/*
					if(!isset($info[$category])) {
						$info[$category] = array();
					}
					$info[$category][] = $file;
					*/
				}

				//$infoJSON = json_encode($info);
				
				$fileInfo = fopen("./images/device_icons/info.json", "a");
				if($fileInfo != false) {  			
		  			fputs ($fileInfo, json_encode($files));
		  			fclose ($fileInfo);
		  		}
			}
		}
		else if(!file_exists('./images/device_icons/'.$imageName)) { 
			
			return Response::view('errors.missing', array(), 404);
		}
		
		$headers = array(
		  'Content-Type' => 'application/octet-stream',//application/pdf',
		);
		
		return Response::download('./images/device_icons/'.$imageName, $imageName, $headers);
	}

	public function doGetHelpFiles($fileName) {
		
		if(!file_exists('./file/'.$fileName)) { 
			return "FALSE";//Response::view('errors.missing', array(), 404);
		}

		$headers = array(
		  'Content-Type' => 'application/octet-stream',//application/pdf',
		);
		return Response::download('./file/'.$fileName, $fileName, $headers);
	}

	public function doGetTwowayFiles($devType, $fileName) {
		
		if(!file_exists('./file/'.$devType.'/twoway'.'/'.$fileName)) { 
			return "FALSE";//Response::view('errors.missing', array(), 404);
		}

		$headers = array(
		  'Content-Type' => 'application/octet-stream',//application/pdf',
		);
		return Response::download('./file/'.$devType.'/twoway'.'/'.$fileName, $fileName, $headers);
	}

	public function doGetDeviceFiles($devType, $fileName) {

		if(!file_exists('./file/'.$devType.'/'.$fileName)) { 
			return "FALSE";//Response::view('errors.missing', array(), 404);
		}

		$headers = array(
		  'Content-Type' => 'application/octet-stream',//application/pdf',
		);
		return Response::download('./file/'.$devType.'/'.$fileName, $fileName, $headers);
	}

	public function doGetDeviceInfo($devType, $macAddr) {


		if(URCValues::isBasestation($devType)) {

			$bstationObj = DB::table('a_bstations')->where('mac', '=', $macAddr)->first();
			if(!$bstationObj) {
				return Response::json(array('master' => 0, 'prg_type' => 'unknown'));
			}

			$prg = 'public';		
			$dnData = DB::table('a_download')->where('room_id', '=', $bstationObj->room_id)->first();
			if($dnData) {
				switch($dnData->link_prg_version) {
				case 0:
					$prg = 'public';
					break;
				case 1:
					$prg = 'beta';
					break;
				case 2:
					$prg = 'alpha';
					break;
				case 3:
					$prg = 'rc';
					break;
				case 4:
					$prg = 'factory';
					break;
				case 5:
					$prg = 'eng';
					break;
				}
			}

			if(!$bstationObj->master) {
				return Response::json(array('master' => 0, 'prg_type' => $prg));
			}

			return Response::json(array('master' => 1, 'prg_type' => $prg));
		}

		if(URCValues::isRemoteControl($devType)) {

			$master_mac = 'unknown';
			$download_key = 'unknown';
			$remoteObj = DB::table('a_remotes')->where('mac', '=', $macAddr)->first();
			if(!$remoteObj) {
				return Response::json(array('prg_type' => 'unknown', 'download_key' => 'unknown', 'master' => 'unknown'));
			}

			$prg = 'public';		
			$dnData = DB::table('a_download')->where('room_id', '=', $remoteObj->room_id)->first();
			if($dnData) {
				switch($dnData->link_prg_version) {
				case 0:
					$prg = 'public';
					break;
				case 1:
					$prg = 'beta';
					break;
				case 2:
					$prg = 'alpha';
					break;
				case 3:
					$prg = 'rc';
					break;
				case 4:
					$prg = 'factory';
					break;
				case 5:
					$prg = 'eng';
					break;
				}

				$chkHdr = json_decode($dnData->data);
				$download_key = $chkHdr->header->download_key;
				$master_mac = $chkHdr->header->bstation_mac;
			}

			return Response::json(array('prg_type' => $prg, 'download_key' => $download_key, 'master' => $master_mac));
		}

		return Response::json(array('prg_type' => 'unknown', 'download_key' => 'unknown', 'master' => 'unknown'));
	}

}