<?php

require_once('DataGenerator.php');
require_once('BStationManager.php');

class DownloadController extends BaseController {

	public function doDownloadTest() {

		$rules = array(
				'username' => 'Required',
				'password' => 'Required',
				'mac' => 'required');

		$v = Validator::make(Input::all(), $rules);
		if($v->fails()) {
			return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
		}

		$username = Input::get('username');
		$password = Input::get('password');
		$bstationMac = Input::get('mac');
		
		//check ID Password
		$editor_type = Config::get('editorenv.editor_type');
		$userChk = User::where('username', '=', $username)->where('editor', '=', $editor_type)->first();

		if(!$userChk) {
			//ErrorDebug::write(Crypt::decrypt($userChk->password));
			return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
		}

		if($password !== Crypt::decrypt($userChk->password)) {
			return Response::json(array('result' => false, 'error' => 'Your username or password is incorrect.'));
		}

		$bstation = DB::table('a_bstations')->where('mac', '=', $bstationMac)->first();
		if(!$bstation) {
			return Response::json(array('result' => false, 'error' => 'No basestation found.'));
		}		
		$systemId = $bstation->system_id;

		if(!URCSystemData::isValidSystem($userChk->id, $systemId)) {
			return Response::json(array('result' => false, 'error' => 'Not valid for this user.'));
		}

		$systemChk = DB::table('a_systems')->where('user_id', '=', $userChk->id)->
			where('id', '=', $systemId)->first();
		if(!$systemChk) {
			return Response::json(array('result' => false, 'error' => 'No system found.'));
		}
		if($systemChk->job_done != 1) {
			return Response::json(array('result' => false, 'error' => 'Importing is not finished'));
		}

		$mgr = new BStationManager(URCValues::WAIT_SEC); 
		$controllerId = URCSystemData::getControllerId($userChk->id, $systemId);	

		$sip_user = DB::table('sip_user')->where('controller_id', '=', $controllerId)->first();
		if(!$sip_user) {
			return Response::json(array('result' => false, 'error' => 'Not valid communication account'));
		}
		$passwordSip = Crypt::decrypt($sip_user->password);
		if($mgr->customCheckConnection($sip_user->sip_id, $passwordSip, $controllerId) !== true) {
			return Response::json(array('result' => false, 'error' => 'basestation is not found'));
		}

		//get download data			
		$downData = DB::table('a_download')->where('id', '=', $userChk->id)->
			where('type', '=', URCValues::DOWN_TYPE_BSTATION)->
			where('system_id', '=', $systemId)->first();
		if(!$downData) {
			return Response::json(array('result' => false, 'error' => 'no data found'));
		}
			
		//$worker = new DownloadThread($mgr, $data);
		//$worker->start();

		set_time_limit('600');

		if($mgr->customDownStart($sip_user->sip_id, $passwordSip, $controllerId, $downData->link_data) === false) {
			return Response::json(array('result' => false, 'error' => $mgr->getErrResult()));
	    }

	    $downResult = true;
		while($mgr->customDownProgress() < 100) {
		    
			if($mgr->customDownSend(false) == false) {
		    	$mgr->customDownStop('upgrade');
		    	return Response::json(array('result' => false, 'error' => $mgr->getErrResult()));
		    }

		}

		return Response::json(array('result' => true));			
	}
	
	public function doDownload($funcType, $systemId = -1, $roomId = -1) {

		if($funcType == 'generate_old') {
			
			$timeTestSt = microtime();
			ErrorDebug::write(' ');
			ErrorDebug::write(date("Y-m-d H:i:s"));

			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}

			ErrorDebug::write('st-2:'.URCValues::microtime_gap($timeTestSt, microtime()));

			if(!$this->chkUser()) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}
			ErrorDebug::write('st-1:'.URCValues::microtime_gap($timeTestSt, microtime()));

			$controllerId = URCSystemData::getControllerId($this->usr_id/*//JWT->Auth::id()*/, $systemId);
			$sip_user = DB::table('sip_user')->where('controller_id', '=', $controllerId)->first();
			if(!$sip_user) {
				return Response::json(array('result' => false, 'error' => 'Not valid communication account'));
			}

			ErrorDebug::write('st0:'.URCValues::microtime_gap($timeTestSt, microtime()));

 			$systemChk = DB::table('a_systems')->where('user_id', '=', $this->usr_id)->
				where('id', '=', $systemId)->first();
			/*
			if($systemChk && $systemChk->job_done != 1) {
				return Response::json(array('result' => false, 'error' => 'Importing is not finished'));
			}
			*/
			
			/*
			$room = DB::table('a_rooms')->where('system_id', '=', $systemId)->
				where('master', '=', 1)->first();
			if(!$room) {
				return Response::json(array('result' => false, 'error' => 'no data found'));
			}
			*/

			DB::table('user')->where('id', '=', $this->usr_id/*//JWT->Auth::id()*/)->
				update(array('status' => 'generate'));

			/*
			$mgr = new BStationManager(URCValues::WAIT_SEC); 
			$passwordSip = Crypt::decrypt($sip_user->password);				
			if(Config::get('editorenv.debugSkipBStationChk') != true) {
				if($mgr->customCheckConnection($sip_user->sip_id, $passwordSip, $controllerId) !== true) {
					$errResult = $mgr->getErrResult();
					return Response::json(array('result' => false, 'error' => $errResult));
				}
			}
			*/
			$download_key = StringGenerator::doGen(16, 'AZ09');

			$twowaySysParamMgr = null;
			
			$genBStation = null;
			$genClient = null;

			$dataBStation = null;
			$dataClientSystems = null;
			$arDataClientRoom = array();
			
			ErrorDebug::write('st1:'.URCValues::microtime_gap($timeTestSt, microtime()));

			try
			{		
				//throw new \Exception('Test');		

				$rooms = DB::table('a_rooms')->where('system_id', '=', $systemId)->get();

				$twowaySysParamMgr = new TwowaySysParamGenerator($rooms);
				$twowaySysParamMgr->gather();

				ErrorDebug::write('st2:'.URCValues::microtime_gap($timeTestSt, microtime()));

				$genBStation = new BStationDataGenerator($this->usr_id, $systemId, $download_key, $twowaySysParamMgr);				
				if($genBStation->generate($dataBStation) == false) {
					throw new \Exception('data generating error');
				}

				ErrorDebug::write('st3:'.URCValues::microtime_gap($timeTestSt, microtime()));

				$genClient = new ClientDataGenerator($this->usr_id, $download_key, $twowaySysParamMgr);
				$dataClientSystems = &$genClient->genSystems();
				//ErrorDebug::write('$dataClientSystems:'.json_encode($dataClientSystems));
				
				ErrorDebug::write('st4:'.URCValues::microtime_gap($timeTestSt, microtime()));				

				$dataClientSystem = &$genClient->genSystem($systemId);	
				if($dataClientSystem == false) {
					throw new \Exception('system data generating error');
				}			
				//ErrorDebug::write('$dataClientSystem:'.json_encode($dataClientSystem));
				
				ErrorDebug::write('st5:'.URCValues::microtime_gap($timeTestSt, microtime()));				

				/*
				$testRoom = $dataClientSystem->system->rooms[0];
				$dbBtns = DB::table('a_btns')->where('room_id', '=', $testRoom->id)->select('id', 'display_text')->get();
					//where('device_id', '=', $device->id)->
					//where('page_id', '=' -1)->get();
				ErrorDebug::write('st4-2:'.URCValues::microtime_gap($timeTestSt, microtime()));				
				*/

				foreach($dataClientSystem->system->rooms as &$room) {
					$result = $genClient->genRoom($systemId, $room->id, $dataClientSystem->system->home_btn_option);//('./room'.$room->id.'.json', $system->id, $room->id);
					if($result == false) {
						throw new \Exception('room data generating error');
					}
					$arDataClientRoom[$room->id] = $result;
					ErrorDebug::write('st6:'.URCValues::microtime_gap($timeTestSt, microtime()));				
				}
			}
			catch(\Exception $e) 
			{
				//if($e instanceof QueryException) {
				//	return Response::json(array('result' => false, 'error_QueryException' => $e->getMessage(), 'error_code' => $e->getCode()));		
				//}
				return Response::json(array('result' => false, 'error' => $e->getMessage(), 'error_code' => $e->getCode()));		
			}

			try
			{
				DB::begintransaction();

				ErrorDebug::write('DB1:'.URCValues::microtime_gap($timeTestSt, microtime()));	

				$genBStation = new BStationDataGenerator($this->usr_id, $systemId, $download_key, $twowaySysParamMgr);
				if($genBStation->saveToDBEx($dataBStation) == false) {
					throw new \Exception('data generating error');
				}	

				ErrorDebug::write('DB2:'.URCValues::microtime_gap($timeTestSt, microtime()));	

				//$genClient->saveSystemsToDB($dataClientSystems);//('./systems.json');

				ErrorDebug::write('DB3:'.URCValues::microtime_gap($timeTestSt, microtime()));	

				//foreach($resultSystems->systems as $system) {//just do self system
				$genClient->saveSystemToDB($systemId, $dataClientSystem);//('./system'.$system->id.'.json', $system->id);

				ErrorDebug::write('DB4:'.URCValues::microtime_gap($timeTestSt, microtime()));	
				foreach($arDataClientRoom as $key => $room) {
				
					$genClient->saveRoomToDBEx($systemId, $key, $room);//('./room'.$room->id.'.json', $system->id, $room->id);
					ErrorDebug::write('DB5:'.URCValues::microtime_gap($timeTestSt, microtime()));	
				}
				//}

				DB::commit();
			}
			catch(\Exception $e) 
			{
				DB::rollback();
				
				return Response::json(array('result' => false, 'error' => $e->getMessage()));		
			}

			ErrorDebug::write('DB6:'.URCValues::microtime_gap($timeTestSt, microtime()));	

			//return Response::json(array('result' => false, 'error' => 'test'));		


			/*	
			try
			{
				DB::begintransaction();

				$rooms = DB::table('a_rooms')->where('system_id', '=', $systemId)->get();

				$twowaySysParamMgr = new TwowaySysParamGenerator($rooms);
				$twowaySysParamMgr->gather();

				$genBStation = new BStationDataGenerator($this->usr_id, $systemId, $download_key, $twowaySysParamMgr);
				if($genBStation->saveToDB() == false) {
					throw new \Exception('data generating error');
				}	
				$genClient = new ClientDataGenerator($this->usr_id, $download_key, $twowaySysParamMgr);
				$resultSystems = &$genClient->genSystems();
				if($resultSystems == false) {
					throw new \Exception('systems data generating error');
				}

				$genClient->saveSystemsToDB($resultSystems);//('./systems.json');
				//foreach($resultSystems->systems as $system) {//just do self system
					$resultSystem = &$genClient->genSystem($systemId);
					if($resultSystem == false) {
						throw new \Exception('system data generating error');
					}
					$genClient->saveSystemToDB($systemId, $resultSystem);//('./system'.$system->id.'.json', $system->id);

					foreach($resultSystem->system->rooms as $room) {
						$genClient->saveRoomToDB($systemId, $room->id, $resultSystem->system->home_btn_option);//('./room'.$room->id.'.json', $system->id, $room->id);
					}
				//}

				DB::commit();
			}
			catch(\Exception $e) 
			{
				DB::rollback();
				
				return Response::json(array('result' => false, 'error' => $e->getMessage()));		
			}
			*/

			$amazonObj = new URCAmazonData($systemId);
			$amazonService = $amazonObj->getServiceObj();
			if($amazonService) {
				$amazonObj->registerToMCS($amazonService->link_code);
			}

			return Response::json(array('result' => false));	
		}

		if($funcType == 'generate') {
			
			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}

			if(!$this->chkUser()) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}
			
			$controllerId = URCSystemData::getControllerId($this->usr_id/*//JWT->Auth::id()*/, $systemId);
			$sip_user = DB::table('sip_user')->where('controller_id', '=', $controllerId)->first();
			if(!$sip_user) {
				return Response::json(array('result' => false, 'error' => 'Not valid communication account'));
			}

 			$systemChk = DB::table('a_systems')->where('user_id', '=', $this->usr_id)->
				where('id', '=', $systemId)->first();
			/*
			if($systemChk && $systemChk->job_done != 1) {
				return Response::json(array('result' => false, 'error' => 'Importing is not finished'));
			}
			*/
			
			/*
			$room = DB::table('a_rooms')->where('system_id', '=', $systemId)->
				where('master', '=', 1)->first();
			if(!$room) {
				return Response::json(array('result' => false, 'error' => 'no data found'));
			}
			*/

			DB::table('user')->where('id', '=', $this->usr_id/*//JWT->Auth::id()*/)->
				update(array('status' => 'generate'));

			$mgr = new BStationManager(URCValues::WAIT_SEC); 
			$passwordSip = Crypt::decrypt($sip_user->password);				
			if(Config::get('editorenv.debugSkipBStationChk') != true) {
				if($mgr->customCheckConnection($sip_user->sip_id, $passwordSip, $controllerId) !== true) {
					$errResult = $mgr->getErrResult();
					return Response::json(array('result' => false, 'error' => $errResult));
				}
			}
			
			//$twowaySysParamMgr = null;
			
			$genBStation = null;
			$genClient = null;

			$dataBStation = null;
			$dataClientSystems = null;
			$arDataClientRoom = null;

			$errMsg = '';
			$result = '';
			for($retryCnt = 0; $retryCnt < URCValues::DB_MAX_RETRY; $retryCnt++) {
				
				//$result = call_user_func_array(array($this, "gatherDownloadData"), array($systemId, &$genBStation, &$genClient, &$dataBStation, &$dataClientSystems, &$arDataClientRoom, &$errMsg));
				$result = $this->gatherDownloadData($systemId, $genBStation, $genClient, $dataBStation, $dataClientSystems, $arDataClientRoom, $errMsg);
				if($result !== URCValues::FUNC_RET_DEADLOCK) { break; }

				ErrorDebug::write('gather Deadlock idx : '.$retryCnt);
			}
			if($result !== URCValues::FUNC_RET_TRUE) {
				return Response::json(array('result' => false, 'error' => $errMsg));
			}

			for($retryCnt = 0; $retryCnt < URCValues::DB_MAX_RETRY; $retryCnt++) {
				
				$errMsg = '';
				$result = $this->saveDownloadData($systemId, $genBStation, $genClient, $dataBStation, $dataClientSystems, $arDataClientRoom, $errMsg);
				if($result !== URCValues::FUNC_RET_DEADLOCK) { break; }

				ErrorDebug::write('save Deadlock idx : '.$retryCnt);
			}
			if($result !== URCValues::FUNC_RET_TRUE) {
				return Response::json(array('result' => false, 'error' => $errMsg));
			}

			$amazonObj = new URCAmazonData($systemId);
			$amazonService = $amazonObj->getServiceObj();
			if($amazonService) {
				$amazonObj->registerToMCS($amazonService->link_code);
			}

			return Response::json(array('result' => false));	
		}

		if($funcType == 'server_start') {

			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				echo ';ERROR : Invalid user name';
				return;
			}
			if(!$this->chkUser()) {
				echo ';ERROR : Invalid user name';
				return;
			}

			$controllerId = URCSystemData::getControllerId($this->usr_id/*//JWT->Auth::id()*/, $systemId);
			$sip_user = DB::table('sip_user')->where('controller_id', '=', $controllerId)->first();
			if(!$sip_user) {
				echo ';ERROR : Not valid communication account';
				return;
			}

			//ErrorDebug::write('server_start');
			
			/*
			$room = DB::table('a_rooms')->where('system_id', '=', $systemId)->
				where('master', '=', 1)->first();
			if(!$room) {
				return Response::json(array('result' => false, 'error' => 'no data found'));
			}
			*/

			//Communication with Server
			$mgr = new BStationManager(URCValues::WAIT_SEC); 

			$mac_addr = BStationmanager::getMACFromControllerId($controllerId);	    	
			$mgr->chkLogController($mac_addr, 'downloading', 'start download', 5);
			
			$passwordSip = Crypt::decrypt($sip_user->password);			
			if(Config::get('editorenv.debugSkipBStationChk') != true) {	
			
				if($mgr->customCheckConnection($sip_user->sip_id, $passwordSip, $controllerId) !== true) {
					echo ';ERROR : '.$mgr->getErrResult();
					return;// Response::json(array('result' => false, 'error' => 'basestation is not found'));
				}
			}

			//get download data			
			$downData = DB::table('a_download')->where('id', '=', $this->usr_id/*//JWT->Auth::id()*/)->
				where('type', '=', URCValues::DOWN_TYPE_BSTATION)->
				where('system_id', '=', $systemId)->first();
			if(!$downData) {
				echo ';ERROR : no data found';
				return;// Response::json(array('result' => false, 'error' => 'no data found'));
			}
			
			//$worker = new DownloadThread($mgr, $data);
			//$worker->start();

			set_time_limit('600');

			header('Content-Type: application/octet-stream');
			header('Cache-Control: no-cache'); // recommended to prevent caching of event data.

			// Turn off output buffering
			ini_set('output_buffering', 'off');
			// Turn off PHP output compression
			ini_set('zlib.output_compression', false);
			// Implicitly flush the buffer(s)
			ini_set('implicit_flush', true);
			ob_implicit_flush(true);
			// Clear, and turn off output buffering
			while (ob_get_level() > 0) {
			    // Get the curent level
			    $level = ob_get_level();
			    // End the buffering
			    ob_end_clean();
			    // If the current level has not changed, abort
			    if (ob_get_level() == $level) break;
			}   

			$userStatusChk = DB::table('user')->where('id', '=', $this->usr_id/*//JWT->Auth::id()*/)->first();
			if($userStatusChk->status === 'stop') {
				//ErrorDebug::write('stop force');
				return;
			}

			DB::table('user')->where('id', '=', $this->usr_id/*//JWT->Auth::id()*/)->
				update(array('status' => 'start'));

			/*
			if($mgr->customDownStart($sip_user->sip_id, $passwordSip, $controllerId, $downData->data) === false) {
		    	echo ';ERROR : '.$mgr->getErrResult();
		    }
		    else {
		    	echo ';0';
		    }

		    $downResult = true;
			while($mgr->customDownProgress() < 100) {
			    
				$userData = DB::table('user')->where('id', '=', $this->usr_id)->first();
			    if($userData->status === 'stop') {
			    	//ErrorDebug::write('stop user');
			    	$mgr->customDownStop('upgrade');
			    	$downResult = false;
			    	break;
			    }

			    if($mgr->customDownSend(true) == false) {
			    	$mgr->customDownStop('upgrade');
			    	$downResult = false;
			    	break;
			    }
			    //ErrorDebug::write('progress:'.$mgr->customDownProgress());
			}
			*/

			if($mgr->customDownStartHTTP($sip_user->sip_id, $passwordSip, $controllerId, $downData->data) === false) {
		    	echo ';ERROR : '.$mgr->getErrResult();
		    }
		    else {
		    	echo ';0';
		    }

		    $downResult = true;
		    //$doneRetry = 0;
		    $time = microtime();
			while($mgr->customDownProgress() < 100) {
			    
				$userData = DB::table('user')->where('id', '=', $this->usr_id)->first();
			    if($userData->status === 'stop') {
			    	//ErrorDebug::write('stop user');
			    	$mgr->customDownStop('db_down_http');
			    	$downResult = false;
			    	break;
			    }
			    else if($userData->status === 'done') {
			    	
			    	echo ';100';
				    //ob_flush();
				    flush();

				    usleep(100);
			    	break;
			    }
			    else if($mgr->customDownSendHTTPStatus() === false) {
			    	//$mgr->customDownStop('db_down_http');
			    	$dif = URCValues::microtime_gap($time, microtime());
			    	if($dif > 120) {//120 seconds
			    		$downResult = false;
			    		echo ';ERROR : sending error';
						flush();
			    		break;
			    	}
			    }
			    else
			    {
				    $time = microtime();
				}

			    usleep(500000);//0.5 sec
			    //ErrorDebug::write('progress:'.$mgr->customDownProgress());
			}

			//ErrorDebug::write('donRetry'.$doneRetry);

			//update DB Data
			if($downResult === true) {

				for($retryCnt = 0; $retryCnt < URCValues::DB_MAX_RETRY; $retryCnt++) {
				
					$errMsg = '';
					$result = $this->saveDownloadDataToResult($systemId, $errMsg);
					if($result === URCValues::FUNC_RET_DEADLOCK) { 

						ErrorDebug::write('saveToResult Deadlock idx : '.$retryCnt);
						continue;
					}

					if($result !== URCValues::FUNC_RET_TRUE) {
						ErrorDebug::write('critial Error:DB Update');
						ErrorDebug::write($errMsg);
					}

					break;
				}
			}

			//$mgr->doSendData($data);

			//return Response::json(array('result' => true));//, 'data' => $data));
		}

		if($funcType == 'server_stop') {
			
			//ErrorDebug::write('server_stop11');

			if(!$this->chkJWTTokenWithLevel(URCValues::LOGIN_USER, $errMsg, $errNo)) {
				return Response::make($errMsg, $errNo);
			}
			if(!$this->chkUser()) {
				return Response::json(array('result' => false, 'error' => 'Invalid user'));
			}
			
			DB::table('user')->where('id', '=', $this->usr_id/*//JWT->Auth::id()*/)->
				update(array('status' => 'stop'));
			
			//ErrorDebug::write('server_stop');

			return Response::json(array('result' => true));
		}		

		if($funcType == 'server_done') {

			$username = Input::get('username');
			$password = Input::get('password');
			$checksum = Input::get('checksum');

			//$editor_type = Config::get('editorenv.editor_type');
			//$userChk = User::where('username', '=', $username)->where('editor', '=', $editor_type)->first();
		
			$userId = -1;
			//if(!$userChk || $password !== Crypt::decrypt($userChk->password)) {
			if(Input::has('controller_id')) {
				$sip_user = DB::table('sip_user')->where('sip_id', '=', $username)->
					where('controller_id', '=', Input::get('controller_id'))->first();
			}
			else {			
				$sip_user = DB::table('sip_user')->where('sip_id', '=', $username)->first();
			}

				if(!$sip_user || $password !== Crypt::decrypt($sip_user->password)) {
					//ErrorDebug::write('password:'.Crypt::decrypt($sip_user->password));
					return Response::json(array('result' => false, 'error' => 'not valid info'));
				}
			
				//ErrorDebug::write('sip_user'.json_encode($sip_user));

				$system = DB::table('a_systems')->where('controller_id', '=', $sip_user->controller_id)->first();
				if(!$system) {
					return Response::json(array('result' => false, 'error' => 'not valid system'));
				}

				$userId = $system->user_id;

				$downData = DB::table('a_download')->where('id', '=', $userId)->
					where('type', '=', URCValues::DOWN_TYPE_BSTATION)->
					where('system_id', '=', $system->id)->first();			

				$dataChecksum = md5($downData->data);
				//ErrorDebug::write('system_id'.$system->id);
				//ErrorDebug::write('sip_user:'.$username);
				//ErrorDebug::write('controller_id:'.$sip_user->controller_id);
				//ErrorDebug::write('fromDone:'.$dataChecksum);
				//ErrorDebug::write('sum:'.$checksum);
				if($checksum != $dataChecksum) {
					return Response::json(array('result' => false, 'error' => 'checksum error:'.$dataChecksum));
				}
			
			//}
			//else {
			//	$userId = $userChk->id;
			//}

			DB::table('user')->where('id', '=', $userId)->update(array('status' => 'done'));
			return Response::json(array('result' => true));
		}
	}

	protected function gatherDownloadData($systemId, &$genBStation, &$genClient, &$dataBStation, &$dataClientSystems, &$arDataClientRoom, &$errMsg) {
			
		$timeTestSt = microtime();
		$download_key = StringGenerator::doGen(16, 'AZ09');

		ErrorDebug::write('gather1:'.URCValues::microtime_gap($timeTestSt, microtime()));

		try
		{		
			$rooms = DB::table('a_rooms')->where('system_id', '=', $systemId)->get();

			//gather twoways
			$twowaySysParamMgr = new TwowaySysParamGenerator($rooms);
			$twowaySysParamMgr->gather();
			ErrorDebug::write('gather2:'.URCValues::microtime_gap($timeTestSt, microtime()));

			//gather bstation data
			$genBStation = new BStationDataGenerator($this->usr_id, $systemId, $download_key, $twowaySysParamMgr);				
			if($genBStation->generate($dataBStation) == false) {
				throw new \Exception('data generating error');
			}
			ErrorDebug::write('gather3:'.URCValues::microtime_gap($timeTestSt, microtime()));


			//gather client systems
			$genClient = new ClientDataGenerator($this->usr_id, $download_key, $twowaySysParamMgr);
			$dataClientSystems = &$genClient->genSystems();
			//ErrorDebug::write('$dataClientSystems:'.json_encode($dataClientSystems));
			ErrorDebug::write('gather4:'.URCValues::microtime_gap($timeTestSt, microtime()));				

			//gather client system
			$dataClientSystem = &$genClient->genSystem($systemId);	
			if($dataClientSystem == false) {
				throw new \Exception('system data generating error');
			}			
			//ErrorDebug::write('$dataClientSystem:'.json_encode($dataClientSystem));				
			ErrorDebug::write('gather5:'.URCValues::microtime_gap($timeTestSt, microtime()));				


			//gather client room
			$arDataClientRoom = array();
			foreach($dataClientSystem->system->rooms as &$room) {
				$result = $genClient->genRoom($systemId, $room->id, $dataClientSystem->system->home_btn_option);//('./room'.$room->id.'.json', $system->id, $room->id);
				if($result == false) {
					throw new \Exception('room data generating error');
				}
				$arDataClientRoom[$room->id] = $result;
				ErrorDebug::write('gather6:'.URCValues::microtime_gap($timeTestSt, microtime()));				
			}
		}
		catch(\Exception $e) 
		{
			$errMsg = $e->getMessage();
					
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}

			return URCValues::FUNC_RET_FALSE;		
		}

		return URCValues::FUNC_RET_TRUE;
	}

	protected function saveDownloadData($systemId, &$genBStation, &$genClient, &$dataBStation, &$dataClientSystems, &$arDataClientRoom, &$errMsg) {
				
		$timeTestSt = microtime();
		ErrorDebug::write('DB1:'.URCValues::microtime_gap($timeTestSt, microtime()));	

		try
		{
			DB::begintransaction();

			if($genBStation->saveToDBEx($dataBStation) == false) {
				throw new \Exception('data generating error');
			}
			ErrorDebug::write('DB2:'.URCValues::microtime_gap($timeTestSt, microtime()));	

			$genClient->saveSystemsToDB($dataClientSystems);//('./systems.json');
			ErrorDebug::write('DB3:'.URCValues::microtime_gap($timeTestSt, microtime()));	

			//foreach($resultSystems->systems as $system) {//just do self system
			$genClient->saveSystemToDB($systemId, $dataClientSystem);//('./system'.$system->id.'.json', $system->id);
			ErrorDebug::write('DB4:'.URCValues::microtime_gap($timeTestSt, microtime()));	

			foreach($arDataClientRoom as $key => $room) {
			
				$genClient->saveRoomToDBEx($systemId, $key, $room);//('./room'.$room->id.'.json', $system->id, $room->id);
				ErrorDebug::write('DB5:'.URCValues::microtime_gap($timeTestSt, microtime()));	
			}
			//}

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();

			$errMsg = $e->getMessage();
					
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}

			return URCValues::FUNC_RET_FALSE;		
		}

		ErrorDebug::write('DB6:'.URCValues::microtime_gap($timeTestSt, microtime()));	

		return URCValues::FUNC_RET_TRUE;
	}


	protected function saveDownloadDataToResult($systemId, &$errMsg) {

		//gather
		$systemsData = null;
		$arData = null;
		try
		{
			//systems db
			$systemsData = DB::table('a_download')->where('id', '=', $this->usr_id/*//JWT->Auth::id()*/)->
				where('system_id', '=', -1)->first();
			//system db
			$arData = DB::table('a_download')->where('id', '=', $this->usr_id/*//JWT->Auth::id()*/)->
				where('system_id', '=', $systemId)->get();
		}
		catch(\Exception $e) 
		{
			$errMsg = $e->getMessage();
					
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}

			return URCValues::FUNC_RET_FALSE;		
		}
		
		//apply
		try
		{
			DB::begintransaction();

			//systems db
			DB::table('a_download')->where('id', '=', $systemsData->id)->
				where('type', '=', $systemsData->type)->
				where('system_id', '=', $systemsData->system_id)->
				where('room_id', '=', $systemsData->room_id)->
				where('crc', '=', $systemsData->crc)->
				update(array('link_prg_version' => Config::get('editorenv.prg_version'), 'link_crc' => $systemsData->crc, 'link_data' => $systemsData->data));
			
			//system db
			foreach($arData as $dataSub) {
				DB::table('a_download')->where('id', '=', $dataSub->id)->
					where('type', '=', $dataSub->type)->
					where('system_id', '=', $dataSub->system_id)->
					where('room_id', '=', $dataSub->room_id)->
					where('crc', '=', $dataSub->crc)->
					update(array('link_prg_version' => Config::get('editorenv.prg_version'), 'link_crc' => $dataSub->crc, 'link_data' => $dataSub->data));
			}

			DB::commit();
		}
		catch(\Exception $e) 
		{
			DB::rollback();
			
			$errMsg = $e->getMessage();
					
			if($e instanceof PDOException) {
				if($e->getCode() == URCValues::DB_ERR_CODE_DEADLOCK) {
					return URCValues::FUNC_RET_DEADLOCK;
				}
			}

			return URCValues::FUNC_RET_FALSE;		
		}

		return URCValues::FUNC_RET_TRUE;
	}


	public function doFile($devType, $macAddr, $dataFileName) {

		$username = Input::get('username');
		$password = Input::get('password');

		$editor_type = Config::get('editorenv.editor_type');
		$userChk = User::where('username', '=', $username)->where('editor', '=', $editor_type)->first();
		//if(!$userChk || $password !== Crypt::decrypt($userChk->password)) {
		//	return Response::json(array('result' => false, 'error' => 'not valid info'));
		//}
		
		if(URCValues::isBasestation($devType)) {

			//get from data, crc (NOT link_data, link_crc)

			$resultAsHTTP = false;
			if($dataFileName == 'system.json') {
				$resultAsHTTP = true;
			}
			
			$chkExisting = DB::table('a_bstations')->where('mac', '=', $macAddr)->first();
			if(!$chkExisting) {
				if($resultAsHTTP) {
					return Response::make('not valid basestation', 404);
				}
				return Response::json(array('result' => false, 'error' => 'not valid basestation'));
			}

			$room = DB::table('a_rooms')->where('id', '=', $chkExisting->room_id)->first();
			if(!$room || $room->system_id !== $chkExisting->system_id) {
				if($resultAsHTTP) {
					return Response::make('not valid basestation', 404);
				}
				return Response::json(array('result' => false, 'error' => 'not valid basestation'));	
			}

			$system = DB::table('a_systems')->where('id', '=', $room->system_id)->first();
			if(!$system) {
				if($resultAsHTTP) {
					return Response::make('not valid basestation', 404);
				}
				return Response::json(array('result' => false, 'error' => 'not valid basestation'));
			}

			if(!$userChk || $password !== Crypt::decrypt($userChk->password) ||
				$system->user_id !== $userChk->id) {
				$sip_user = DB::table('sip_user')->where('controller_id', '=', $system->controller_id)->first();
				if(!$sip_user || $username !== $sip_user->sip_id || $password !== Crypt::decrypt($sip_user->password)) {
					if($resultAsHTTP) {
						return Response::make('not valid info', 404);
					}
					return Response::json(array('result' => false, 'error' => 'not valid info'));
				}
			}

			if($dataFileName == 'system.json') {
				$downData = DB::table('a_download')->where('id', '=', $system->user_id)->
					where('type', '=', URCValues::DOWN_TYPE_BSTATION)->
					where('system_id', '=', $system->id)->first();

				if(!$downData || !$downData->data || strlen($downData->data) < 5) {

					$response = Response::make('NO Data', 404);
					return $response;				
				}

				$data = $downData->data;
				$response = Response::make($data, 200);
				$response->header('Content-Type', 'application/octet-stream');
				$response->header('Content-Length', strlen($data)); 
				return $response;

				//$data = json_decode($downData->link_data);
				//return Response::json(array('result' => true, 'data' => $data));
			}	

			if($dataFileName == 'system_crc') {

				$downData = DB::table('a_download')->where('id', '=', $system->user_id)->
					where('type', '=', URCValues::DOWN_TYPE_BSTATION)->
					where('system_id', '=', $system->id)->first();

				if(!$downData || !$downData->data || strlen($downData->data) < 5) {

					return Response::json(array('result' => false, 'error' => 'NO Data'));
				}

				return Response::json(array('result' => true, 'data' => $downData->crc));
			}			
			
			return Response::json(array('result' => false, 'error' => 'not valid info'));
		}

		//Clients
		if(!URCValues::isRemoteControl($devType)) {//Remote
			return Response::json(array('result' => false, 'error' => 'not valid device type'));
		}

		//get system
		$chkExisting = DB::table('a_remotes')->where('mac', '=', $macAddr)->first();
		if(!$chkExisting) {
			return Response::json(array('result' => false, 'error' => 'not valid remote'));
		}

		$room = DB::table('a_rooms')->where('id', '=', $chkExisting->room_id)->first();
		if(!$room) {
			return Response::json(array('result' => false, 'error' => 'not valid remote'));	
		}

		$system = DB::table('a_systems')->where('id', '=', $room->system_id)->first();
		if(!$system) {
			return Response::json(array('result' => false, 'error' => 'not valid remote'));
		}

		if(!$userChk || $password !== Crypt::decrypt($userChk->password) ||
			$system->user_id !== $userChk->id) {
			$sip_user = DB::table('sip_user')->where('controller_id', '=', $system->controller_id)->first();
			if(!$sip_user || $username !== $sip_user->sip_id || $password !== Crypt::decrypt($sip_user->password)) {
				return Response::json(array('result' => false, 'error' => 'not valid info'));
			}		
		}

		if($dataFileName == 'systems.json') {

			$downData = DB::table('a_download')->where('id', '=', $system->user_id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_SYSTEMS)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			if(strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			$data = json_decode($downData->link_data);
			return Response::json(array('result' => true, 'data' => $data));
		}

		if($dataFileName == 'system_all_crc') {

			$foundData = DB::table('a_download')->select('type', 'room_id', 'link_crc')->
				where('id', '=', $system->user_id)->
				where('system_id', '=', $system->id)->whereNotNull('link_crc')->get();

			if($foundData) {

				$downData = array();

				$foundRooms = DB::table('a_rooms')->where('system_id', '=', $system->id)->get();

				foreach($foundData as $foundItem) {

					switch($foundItem->type)
					{
					//case URCValues::DOWN_TYPE_CLIENT_SYSTEMS:
					case URCValues::DOWN_TYPE_CLIENT_SYSTEM:
						$downData[] = (object)array('type' => $foundItem->type,
							'room_id' => -1, 'crc' => $foundItem->link_crc);
						break;
					case URCValues::DOWN_TYPE_CLIENT_ROOM:

						$downData[] = (object)array('type' => $foundItem->type,
							'room_id' => $foundItem->room_id, 'crc' => $foundItem->link_crc);
						break;
					}					
				}

				if(count($downData) > 0) {
					return Response::json(array('result' => true, 'data' => $downData));
				}
			}

			return Response::json(array('result' => false, 'error' => 'NO Data'));
		}
		
		if($dataFileName == 'system.json') {

			$downData = DB::table('a_download')->where('id', '=', $system->user_id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_SYSTEM)->
				where('system_id', '=', $system->id)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			$data = json_decode($downData->link_data);
			return Response::json(array('result' => true, 'data' => $data));
		}
		else if($dataFileName == 'system_crc') {

			$downData = DB::table('a_download')->where('id', '=', $system->user_id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_SYSTEM)->
				where('system_id', '=', $system->id)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			return Response::json(array('result' => true, 'data' => $downData->link_crc));
		}
		else if($dataFileName == 'room.json') {

			$downData = DB::table('a_download')->where('id', '=', $system->user_id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_ROOM)->
				where('system_id', '=', $system->id)->
				where('room_id', '=', $room->id)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			$data = json_decode($downData->link_data);
			return Response::json(array('result' => true, 'data' => $data));
		}
		else if($dataFileName == 'room_crc') {

			$downData = DB::table('a_download')->where('id', '=', $system->user_id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_ROOM)->
				where('system_id', '=', $system->id)->
				where('room_id', '=', $room->id)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			return Response::json(array('result' => true, 'data' => $downData->link_crc));
		}
						
		return Response::json(array('result' => false, 'error' => 'not valid info'));
	}

	public function doMobileFile($dataFileName) {

		$username = Input::get('username');
		$password = Input::get('password');

		$editor_type = Config::get('editorenv.editor_type');
		$userChk = User::where('username', '=', $username)->where('editor', '=', $editor_type)->first();
		if(!$userChk || $password !== Crypt::decrypt($userChk->password)) {
			//ErrorDebug::write(Crypt::decrypt($userChk->password));
			return Response::json(array('result' => false, 'error' => 'not valid info'));
		}
		
		if($dataFileName == 'systems.json') {

			$downData = DB::table('a_download')->where('id', '=', $userChk->id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_SYSTEMS)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			if(strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			$data = json_decode($downData->link_data);
			return Response::json(array('result' => true, 'data' => $data));
		}

		//get system
		if(!Input::has('system_id')) {
			return Response::json(array('result' => false, 'error' => 'system_id was missed'));
		}
		$systemId = Input::get('system_id');
		$system = DB::table('a_systems')->where('id', '=', $systemId)->first();
		if(!$system) {
			return Response::json(array('result' => false, 'error' => 'not valid system'));
		}
		if($system->user_id !== $userChk->id) {
			return Response::json(array('result' => false, 'error' => 'not valid info'));
		}

		//system
		if($dataFileName == 'system_all_crc') {

			$foundData = DB::table('a_download')->select('type', 'room_id', 'link_crc')->
				where('id', '=', $userChk->id)->
				where('system_id', '=', $system->id)->whereNotNull('link_crc')->get();

			if($foundData) {

				$downData = array();

				$foundRooms = DB::table('a_rooms')->where('system_id', '=', $system->id)->get();

				foreach($foundData as $foundItem) {

					switch($foundItem->type)
					{
					//case URCValues::DOWN_TYPE_CLIENT_SYSTEMS:
					case URCValues::DOWN_TYPE_CLIENT_SYSTEM:
						$downData[] = (object)array('type' => $foundItem->type,
							'room_id' => -1, 'crc' => $foundItem->link_crc);
						break;
					case URCValues::DOWN_TYPE_CLIENT_ROOM:

						$downData[] = (object)array('type' => $foundItem->type,
							'room_id' => $foundItem->room_id, 'crc' => $foundItem->link_crc);
						break;
					}					
				}

				if(count($downData) > 0) {
					return Response::json(array('result' => true, 'data' => $downData));
				}
			}

			return Response::json(array('result' => false, 'error' => 'NO Data'));
		}

		if($dataFileName == 'system.json') {

			$downData = DB::table('a_download')->where('id', '=', $userChk->id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_SYSTEM)->
				where('system_id', '=', $system->id)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			$data = json_decode($downData->link_data);
			return Response::json(array('result' => true, 'data' => $data));
		}
		else if($dataFileName == 'system_crc') {

			$downData = DB::table('a_download')->where('id', '=', $userChk->id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_SYSTEM)->
				where('system_id', '=', $system->id)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			return Response::json(array('result' => true, 'data' => $downData->link_crc));
		}

		//get room
		if(!Input::has('room_id')) {
			return Response::json(array('result' => false, 'error' => 'room_id was missed'));
		}
		$roomId = Input::get('room_id');
		$room = DB::table('a_rooms')->where('id', '=', $roomId)->first();
		if(!$room || $room->system_id !== (int)$systemId) {
			return Response::json(array('result' => false, 'error' => 'not valid info'));	
		}
		
		if($dataFileName == 'room.json') {

			$downData = DB::table('a_download')->where('id', '=', $userChk->id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_ROOM)->
				where('system_id', '=', $system->id)->
				where('room_id', '=', $room->id)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			$data = json_decode($downData->link_data);
			return Response::json(array('result' => true, 'data' => $data));
		}
		else if($dataFileName == 'room_crc') {

			$downData = DB::table('a_download')->where('id', '=', $userChk->id)->
				where('type', '=', URCValues::DOWN_TYPE_CLIENT_ROOM)->
				where('system_id', '=', $system->id)->
				where('room_id', '=', $room->id)->first();

			if(!$downData || !$downData->link_data || strlen($downData->link_data) < 5) {

				return Response::json(array('result' => false, 'error' => 'NO Data'));
			}

			return Response::json(array('result' => true, 'data' => $downData->link_crc));
		}
						
		return Response::json(array('result' => false, 'error' => 'not valid info'));
	}
}