<?php

require_once('URCSystemData.php');
require_once('DataGenerator.php');

class DealerDeviceController extends BaseController {
	
	public function doDeviceControl($funcType, $customDevId = -1) {

		$dealer_id = '';
		$dealer_grp_id = '';
		$dealer_grp_name = '';

		$result = '';
			
		if(!URCJWTWork::chkJWTTokenDealer($dealer_id, $dealer_grp_id, $dealer_grp_name, $errMsg, $errNo)) {
			return Response::make($errMsg, $errNo);
		}

		if($funcType == 'list') {

			$urcCDevice = new URCCustomDevData($dealer_grp_id, $dealer_id);
			$result = $urcCDevice->getDeviceList();
			if($result === false) {
				return Response::json(array('result' => false, 'error' => 'fail to get the list'));
			}

			return Response::json(array('result' => true, 'devices' => $result));
		}

		if($funcType == 'create') {

			$rules = array(
				'name' => 'Required',
				'roomId' => 'Required|Integer',
				'deviceId' => 'Required|Integer');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			$name = Input::get('name');
			$roomId = Input::get('roomId');
			$deviceId = Input::get('deviceId');

			if(!RMSDealer::isEnoughStoreGap($dealer_id)) {
				return Response::json(array('result' => false, 'error' => "You request was already submitted. Please wait."));
			}
			RMSDealer::updateEditTime($dealer_id);

			$urcCDevice = new URCCustomDevData($dealer_grp_id, $dealer_id);

			$errMsg = '';
			for($retryCnt = 0; $retryCnt < URCValues::DB_MAX_RETRY; $retryCnt++) {
				
				$result = $urcCDevice->save($roomId, $deviceId, $name, $errMsg);
				if($result !== URCValues::FUNC_RET_DEADLOCK) { break; }

				ErrorDebug::write('customdev save Deadlock idx : '.$retryCnt);
			}

			if($result === URCValues::FUNC_RET_TRUE) {
				return Response::json(array('result' => true));
			}
			else {
				return Response::json(array('result' => false, 'error' => $errMsg));
			}
		}

		if($funcType == 'create_from_template') {

			$rules = array(
				'name' => 'Required',
				'roomId' => 'Required|Integer',
				'deviceId' => 'Required|Integer');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			$name = Input::get('name');
			$roomId = Input::get('roomId');
			$deviceId = Input::get('deviceId');

			if(!RMSDealer::isEnoughStoreGap($dealer_id)) {
				return Response::json(array('result' => false, 'error' => "You request was already submitted. Please wait."));
			}
			RMSDealer::updateEditTime($dealer_id);

			$urcCDevice = new URCCustomDevData($dealer_grp_id, $dealer_id);
			
			$errMsg = '';
			for($retryCnt = 0; $retryCnt < URCValues::DB_MAX_RETRY; $retryCnt++) {
				
				$result = $urcCDevice->saveFromTemplate($roomId, $deviceId, $name, $errMsg);
				if($result !== URCValues::FUNC_RET_DEADLOCK) { break; }

				ErrorDebug::write('customdev saveFromTemplate Deadlock idx : '.$retryCnt);
			}

			if($result === URCValues::FUNC_RET_TRUE) {
				return Response::json(array('result' => true));
			}
			else {
				return Response::json(array('result' => false, 'error' => $errMsg));
			}
		}

		if($funcType == 'delete') {

			if($customDevId < 0) {
				return Response::json(array('result' => false, 'error' => 'custom Device Id is wrong'));
			}

			$urcCDevice = new URCCustomDevData($dealer_grp_id, $dealer_id);
			
			$errMsg = '';
			for($retryCnt = 0; $retryCnt < URCValues::DB_MAX_RETRY; $retryCnt++) {
				
				$result = $urcCDevice->delete($customDevId);
				if($result !== URCValues::FUNC_RET_DEADLOCK) { break; }

				ErrorDebug::write('customdev delete Deadlock idx : '.$retryCnt);
			}

			if($result === URCValues::FUNC_RET_TRUE) {
				return Response::json(array('result' => true));
			}
			else {
				return Response::json(array('result' => false, 'error' => 'fail to delete device'));
			}
		}

		if($funcType == 'get_device_info') {

			if($customDevId < 0) {
				return Response::json(array('result' => false, 'error' => 'custom Device Id is wrong'));
			}
			
			$urcCDevice = new URCCustomDevData($dealer_grp_id, $dealer_id);
			$result = $urcCDevice->getDeviceInfo($customDevId);

			if($result === false) {
				return Response::json(array('result' => false, 'error' => 'fail to get device info' ));
			}

			return Response::json(array('result' => true, 'data' => $result));
		}
		
		if($funcType == 'apply') {
			
			if($customDevId < 0) {
				return Response::json(array('result' => false, 'error' => 'custom Device Id is wrong'));
			}

			$rules = array(
				'name' => 'Required',
				'targetType' => 'Required',
				'targetAddr' => 'Required',
				'targetPort' => 'Required|Integer',
				'favEnable' => 'Required',
				'favDelay' => 'Required',
				'favEnter' => 'Required',
				'roomId' => 'Required',
				'repeatMin' => 'Required|Integer',
				'repeatMacro' => 'Required|Integer');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			$name = Input::get('name');
			$target = new stdClass;
			$target->type = Input::get('targetType');
			$target->addr = Input::get('targetAddr');
			$target->port = Input::get('targetPort');

			$attr = new stdClass;
			$attr->repeat_min = Input::get('repeatMin');
			$attr->repeat_macro = Input::get('repeatMacro');			
			if($target->type == URCValues::DB_TYPE_IP ||
				$target->type == URCValues::DB_TYPE_UDP) {
				
				$rules2 = array(
					'rampStart' => 'Required|Integer',
					'rampSpeed' => 'Required|Integer',
					'autoCr' => 'Required');

				$v = Validator::make(Input::all(), $rules2);
				if($v->fails()) {
					return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
				}

				$attr->ramp_start = Input::get('rampStart');
				$attr->ramp_speed = Input::get('rampSpeed');
				$attr->auto_cr = Input::get('autoCr');	
			}

			$favOption =  new stdClass;
			$favOption->enable = Input::get('favEnable');
			if($favOption->enable) {
				$favOption->delay =  Input::get('favDelay');
			}
			else {
				$favOption->delay = 400;
			}
			$favOption->enter = Input::get('favEnter');

			$roomId = Input::get('roomId');

			/*
			$userInfo = Input::get('user_info');
			
			try {
				if(URCJWTWork::parseJWTToken($userInfo, $username, $id, $level, $errMsg, $errNo) === false) {
					return Response::json(array('result' => false, 'error' => $errMsg));
				}
		        
		    } catch (Exception $e) {
		    	if ($e->getMessage() === 'Expired Token') {
		    		$errMsg = 'Expired Token';
					return Response::json(array('result' => false, 'error' => $errMsg));
		    	} else {
		    		$errMsg = 'user not found';
					return Response::json(array('result' => false, 'error' => $errMsg));
		    	}
	    	}
	    	*/

	    	if(!RMSDealer::isEnoughStoreGap($dealer_id)) {
				return Response::json(array('result' => false, 'error' => "You request was already submitted. Please wait."));
			}
			RMSDealer::updateEditTime($dealer_id);

			$urcCDevice = new URCCustomDevData($dealer_grp_id, $dealer_id);

			$errMsg = '';
			for($retryCnt = 0; $retryCnt < URCValues::DB_MAX_RETRY; $retryCnt++) {
				
				$result = $urcCDevice->apply($customDevId, $roomId, $name, $target, $attr, $favOption, $errMsg);
				if($result !== URCValues::FUNC_RET_DEADLOCK) { break; }

				ErrorDebug::write('customdev apply Deadlock idx : '.$retryCnt);
			}

			if($result === URCValues::FUNC_RET_TRUE) {
				return Response::json(array('result' => true));
			}
			else {
				return Response::json(array('result' => false, 'error' => $errMsg ));
			}
		}

		if($funcType == 'apply_to_template') {
			
			if($customDevId < 0) {
				return Response::json(array('result' => false, 'error' => 'custom Device Id is wrong'));
			}

			$rules = array(
				'name' => 'Required',
				'targetType' => 'Required',
				'targetAddr' => 'Required',
				'targetPort' => 'Required|Integer',
				'favEnable' => 'Required',
				'favDelay' => 'Required',
				'favEnter' => 'Required',
				'roomId' => 'Required',
				'repeatMin' => 'Required|Integer',
				'repeatMacro' => 'Required|Integer');

			$v = Validator::make(Input::all(), $rules);
			if($v->fails()) {
				return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
			}

			$name = Input::get('name');
			$target = new stdClass;
			$target->type = Input::get('targetType');
			$target->addr = Input::get('targetAddr');
			$target->port = Input::get('targetPort');

			$attr = new stdClass;
			$attr->repeat_min = Input::get('repeatMin');
			$attr->repeat_macro = Input::get('repeatMacro');			
			if($target->type == URCValues::DB_TYPE_IP ||
				$target->type == URCValues::DB_TYPE_UDP) {
				
				$rules2 = array(
					'rampStart' => 'Required|Integer',
					'rampSpeed' => 'Required|Integer',
					'autoCr' => 'Required');

				$v = Validator::make(Input::all(), $rules2);
				if($v->fails()) {
					return Response::json(array('result' => false, 'error' => implode("\n", $v->messages()->all())));
				}

				$attr->ramp_start = Input::get('rampStart');
				$attr->ramp_speed = Input::get('rampSpeed');
				$attr->auto_cr = Input::get('autoCr');	
			}

			$favOption =  new stdClass;
			$favOption->enable = Input::get('favEnable');
			if($favOption->enable) {
				$favOption->delay =  Input::get('favDelay');
			}
			else {
				$favOption->delay = 400;
			}
			$favOption->enter = Input::get('favEnter');

			$roomId = Input::get('roomId');

			if(!RMSDealer::isEnoughStoreGap($dealer_id)) {
				return Response::json(array('result' => false, 'error' => "You request was already submitted. Please wait."));
			}
			RMSDealer::updateEditTime($dealer_id);

			$urcCDevice = new URCCustomDevData($dealer_grp_id, $dealer_id);
		
			$errMsg = '';
			for($retryCnt = 0; $retryCnt < URCValues::DB_MAX_RETRY; $retryCnt++) {
				
				$result = $urcCDevice->applyToTemplate($customDevId, $roomId, $name, $target, $attr, $favOption, $errMsg);
				if($result !== URCValues::FUNC_RET_DEADLOCK) { break; }

				ErrorDebug::write('customdev applyToTemplate Deadlock idx : '.$retryCnt);
			}

			if($result === URCValues::FUNC_RET_TRUE) {
				return Response::json(array('result' => true));
			}
			else {
				return Response::json(array('result' => false, 'error' => $errMsg ));
			}
		}
	}
}